﻿using Microsoft.ComplexEventProcessing;
using System;
using System.ServiceModel;
using Microsoft.ComplexEventProcessing.ManagementService;
using Microsoft.ComplexEventProcessing.Linq;
using SocialAnalyzer.CommonObjects.Adapter;



namespace SocialAnalyzer
{
    class SocialAnalyzer
    {
        
        /// <summary>
        /// CEPServer main method. 
        /// </summary>
        /// <param name="args"></param>
        static void Main(string[] args)
        {

            // In-process: create StreamInsight server to connect to
            Server tweetAnalyzeServer = Server.Create("testinstance");
            
            //Connect to Remote Server:
            //Server tweetAnalyzeServer = Server.Connect(new System.ServiceModel.EndpointAddress("http://localhost/StreamInsight/TestInstance"));
           
            // Create endpoint to let StreamInsight clients connect 
            ServiceHost host = new ServiceHost(tweetAnalyzeServer.CreateManagementService());
            host.AddServiceEndpoint(typeof(IManagementService), new WSHttpBinding(SecurityMode.Message),
                "http://localhost:8090/TweetAnalyzeServer");
            host.Open();

           
            try
            {
                //Create the CEP application
                Application tweetAnalyzerApp = tweetAnalyzeServer.CreateApplication("SocialAnalyzer");               
                 
                //Create a  stream using the Twitter input adatpter
                var inputstream = CepStream<Tweet>.Create("twitterInput", typeof(TwitterAdapterFactory),
                    ConfigureAdapters.GetTwitterAdapterSettings(), EventShape.Point);

                //define a query for the stream in LINQ
                //var twitterQuery = from e in inputstream
                //                   select e;


                //define another query 
                CepStream<SocialNetworkText> twitterEnglishQuery = from t in inputstream
                                                                   where t.UserLang == "en"
                                                                   select new SocialNetworkText { Title = "Tweet", Time = t.CreatedAt.ToString(), Text = t.Text, Language = t.Source };


                //Hopping Window
                //var countTweetsForLanguage = from c in twitterEnglishQuery
                //                             .HoppingWindow<SocialNetworkText>(TimeSpan.FromSeconds(30),
                //                             TimeSpan.FromSeconds(10))
                //                             select new { count = c.Count(), c };

                var myQuery = twitterEnglishQuery.ToQuery(tweetAnalyzerApp, "Microsoft Query",
                    "Retrieves all texts where the keyword Microsoft appears",
                   typeof(SqlOutputFactory), ConfigureAdapters.GetSqlOutputSettings(),
                   EventShape.Point, StreamEventOrder.ChainOrdered);
               

               //// Count Window
               // var countTweetsForLanguage = from c in twitterQuery
               //                              .CountByStartTimeWindow<Tweet>(10)
               //                              select new { count = c.Count(), c };
               // //Snapshot Window
               // var countTweetsForLanguage = from c in twitterQuery
               //                              .SnapshotWindow()
               //                              select new { count = c.Count(), c };


                //var myQuery = countTweetsForLanguage.ToQuery(tweetAnalyzerApp, "Microsoft Query",
                //    "Retrieves all texts where the keyword Microsoft appears",
                //   typeof(ConsoleFactory), new ConsoleConfig(),
                //   EventShape.Point, StreamEventOrder.ChainOrdered);
                
                //myQuery.Start();

                var groupTweets = from v in inputstream
                                  group v by v.UserLang into langGroup
                                  from window in langGroup.SnapshotWindow()
                                  select window;


                SyndicationAdapterConfig rssConfig = ConfigureAdapters.GetRSSAdapterSettings();
                var dataFeedStream =
                    CepStream<SyndicationEvent>.Create("rssInput", typeof(SyndicationAdapterFactory),
                    rssConfig, EventShape.Point);

                string keyword = rssConfig.keyword;
                string language = rssConfig.language;

                CepStream<SocialNetworkText> rssquery =
                            from s1 in dataFeedStream
                            where s1.title.Contains(keyword)
                            select new SocialNetworkText
                            {
                                Title = s1.title,
                                Time = s1.lastUpdateTime.ToString(),
                                Text = s1.summary,
                                Language = language
                            };

                var unionOfTexts = twitterEnglishQuery.Union(rssquery);


                var overallQuery = unionOfTexts.ToQuery(tweetAnalyzerApp, "Microsoft Query",
                    "Retrieves all texts where the keyword Microsoft appears",
                   typeof(SqlOutputFactory), ConfigureAdapters.GetSqlOutputSettings(),
                   EventShape.Point, StreamEventOrder.ChainOrdered);

                //starts the query tree
                overallQuery.Start();

            }
            catch (Exception ex)
            {
                System.Console.WriteLine("Exception occurred: " + ex.Message);                
              
            }

        }
        
    }

}
