﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.ComplexEventProcessing.Adapters;
using Microsoft.ComplexEventProcessing;
using System.Xml;
using System.ServiceModel.Syndication;

namespace SocialAnalyzer.CommonObjects.Adapter
{
    /// <summary>
    /// Retrieves entries from the RSS feed specified by the url in the 
    /// passed configuration object. 
    /// </summary>
    public class RSSInputAdapter : TypedPointInputAdapter<SyndicationEvent>
    {
        private SyndicationFeed dataFeed;
        private IEnumerator<SyndicationItem> dataFeedItems;
        private PointEvent<SyndicationEvent> pendingevent;
        private SyndicationAdapterConfig config;

        /// <summary>
        /// Configures the adapter object.
        /// </summary>
        /// <param name="config">The configuration details for this adapter.</param>
        public RSSInputAdapter(SyndicationAdapterConfig config)
        {
            this.config = config;
        }

        /// <summary>
        /// Connects to the RSS feed specified by the url in the configuration,
        /// retrieves the feed's entries, and stores them in an enumerator.
        /// </summary>
        private void RetrieveRSSEvents()
        {
            //try 
            // {	        
            Rss20FeedFormatter rssformatter = new Rss20FeedFormatter(typeof(SyndicationFeed));
            XmlReader rssreader = XmlReader.Create(this.config.url);
            rssformatter.ReadFrom(rssreader);
            rssreader.Close();
            dataFeed = rssformatter.Feed;
            dataFeedItems = dataFeed.Items.GetEnumerator();
        }

        /// <summary>
        /// Is called once, everytime the process is put in the 
        /// Ready() state again.
        /// Retrieves new events from the rss feed and
        /// produces the corresponding events.
        /// </summary>
        public override void Resume()
        {
            RetrieveRSSEvents();
            ProduceEvents();  
        }

        /// <summary>
        /// Is called once by the server when the query is started.
        /// Retrieves all entries from the feed and produces the 
        /// corresponding events.
        /// </summary>
        public override void Start()
        {
            while (true)
            {
                RetrieveRSSEvents();
                ProduceEvents();
            }            
        }

        /// <summary>
        /// 
        /// </summary>
        private void ProduceEvents()
        {
            //keeps track of the current event created
            PointEvent<SyndicationEvent> currevent =
                default(PointEvent<SyndicationEvent>);
            //tracks the result of the last Enqueue call
            EnqueueOperationResult result = EnqueueOperationResult.Full;
            //RetrieveRSSEvents();

            //while (true)
            //{
                if (AdapterState.Stopping == AdapterState)
                {
                    this.Stopped();
                    return;
                }

                // creates the next event of the next available entry
                while (dataFeedItems.MoveNext())
                {
                    currevent = CreateEventFromSource();
                    pendingevent = null;

                    //Enqueue the new event 
                    if (currevent != null)
                    {
                        result = Enqueue(ref currevent);
                        result = EnqueueCtiEvent(DateTime.Now);
                        if (result == EnqueueOperationResult.Full)
                        {
                            Ready();
                            return;

                        }
                    }
                }

        }

        /// <summary>
        /// Implements behaviour before the adapter is stopped.
        /// The memory of last created event object is released.
        /// </summary>
        /// <param name="currevent">The last event</param>
        private void PrepareToStop(PointEvent<SyndicationEvent> currevent)
        {
            if (null != currevent)
            {
                ReleaseEvent(ref currevent);
                Ready();
            }
        }

        /// <summary>
        /// Implements behaviour before the adapter is resumed.
        /// </summary>
        /// <param name="currevent">The last created event.</param>
        private void PrepareToResume(PointEvent<SyndicationEvent> currevent)
        {
            pendingevent = currevent;
        }

        /// <summary>
        /// Behaviour when the adapter is destroyed.
        /// </summary>
        /// <param name="disposing"></param>
        protected override void Dispose(bool disposing)
        {
            base.Dispose(disposing);
        }


        /// <summary>
        /// Gets the next event from the enumerator of feed entries and
        /// creates an snydication edge event for the entry.
        /// </summary>
        /// <returns>The new edge event.</returns>
        private PointEvent<SyndicationEvent> CreateEventFromSource()
        {
                PointEvent<SyndicationEvent> syndicationEvent = this.CreateInsertEvent();
                syndicationEvent.Payload = new SyndicationEvent(dataFeedItems.Current);
                syndicationEvent.StartTime = DateTime.Now;                               
                return syndicationEvent;
        }


    }
    
}
