﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.ComplexEventProcessing.Adapters;
using Microsoft.ComplexEventProcessing;

namespace SocialAnalyzer.CommonObjects.Adapter

{
    /// <summary>
    /// Factory to create different kinds of Snydication input adapter
    /// dependent on the event type.
    /// </summary>
    public class SyndicationAdapterFactory: IInputAdapterFactory<SyndicationAdapterConfig>
    {

        /// <summary>
        /// Creates a new object of the snydication input adapter of
        /// handling events of the type passed in shape.
        /// </summary>
        /// <param name="config">Contains the configuration details for the 
        /// adapter to be created.</param>
        /// <param name="shape">The event type handled by the adapter, e.g., edge, point</param>
        /// <returns>The created input adapter.</returns>
        public InputAdapterBase Create(SyndicationAdapterConfig config, EventShape shape,
            CepEventType type)
        {
            InputAdapterBase adapter = default(InputAdapterBase);
            if (shape == EventShape.Point)
            {
                adapter = new RSSInputAdapter(config);                
            }
            return adapter;
        }


        /// <summary>
        /// Behaviour when the object is removed from memory.
        /// </summary>
        public void Dispose()
        {
            
        }
       
    }
}
