﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.ServiceModel.Syndication;


namespace SocialAnalyzer.CommonObjects.Adapter
{
    /// <summary>
    /// Encapsulates an event describing an RSS feed entry
    /// </summary>
    public class SyndicationEvent
    {
        public string id { get; set; }
        public string title { get; set; }
        public string summary { get; set; }
        public string text { get; set; }
        public string uri { get; set; }
        public DateTime createdTime { get; set; }
        public DateTime lastUpdateTime { get; set; }
        public string author { get; set; }

        /// <summary>
        /// Initializes the object with information from the 
        /// passed item.
        /// </summary>
        /// <param name="item">Contains information about the RSS feed entry.</param>
        public SyndicationEvent(SyndicationItem item) {
            id = item.Id;
            title = item.Title.Text;
            //Create a summary of the entry text
            //if (item.Summary.Text.Length > 256) 
            //    summary = item.Summary.Text.Substring(0, 256); 
            //else  
            summary = item.Summary.Text;
            //text = item.Content.ToString();
            createdTime = item.PublishDate.DateTime;
            lastUpdateTime = item.LastUpdatedTime.DateTime;
            //only pick the first author
            if (item.Authors.Count > 0)
                author = item.Authors[0].Name;
        }

        /// <summary>
        /// The empty constructor without initialization.
        /// </summary>
        public SyndicationEvent() 
        { }

    }
}
