﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.ComplexEventProcessing.Adapters;
using Microsoft.ComplexEventProcessing;

namespace SocialAnalyzer.CommonObjects.Adapter
{
    public class TwitterAdapterFactory : ITypedInputAdapterFactory<TwitterConfig>
    {
        
        public InputAdapterBase Create<TPayload>(TwitterConfig configInfo, 
            EventShape eventShape)
        {
            InputAdapterBase twitterAdapter = null;
            if (eventShape == EventShape.Point)
            {
                twitterAdapter = new TwitterInputAdapter(configInfo, eventShape);
            }
           return twitterAdapter;
        }
        public void Dispose()
        {
            throw new NotImplementedException();
        }
    }
}
