﻿using SocialAnalyzer.CommonObjects.Adapter;
using System;
using System.Collections.Generic;
using System.Linq;

namespace SocialAnalyzer
{
    public class ConfigureAdapters
    {
        //    /// <summary>
        //    /// Retrieves the settings from the Twitter settings files
        //    /// </summary>
        //    /// <returns>A config object with the current settings.</returns>
        public static TwitterConfig GetTwitterAdapterSettings()
        {
            TwitterConfig config = new TwitterConfig();
            config.url = Twitter.Default.URL;
            config.Username = Twitter.Default.UserName;
            config.method = Twitter.Default.Method;
            config.Parameters = Twitter.Default.TrackParameterValue;
            config.Password = Twitter.Default.Password;
            config.Timeout = Twitter.Default.Timeout;
            return config;
        }

        public static SqlOutputConfig GetSqlOutputSettings()
        {
            SqlOutputConfig sqlconfig = new SqlOutputConfig();
            sqlconfig.ConnectionString = SqlOutputConfigSet.Default.ConnectionString;
            sqlconfig.EndTimeColumnName = SqlOutputConfigSet.Default.EndTimeColumnName;
            sqlconfig.StartTimeColumnName = SqlOutputConfigSet.Default.StartTimeColumnName;
            sqlconfig.TableName = SqlOutputConfigSet.Default.TableName;
            sqlconfig.Statement = SqlOutputConfigSet.Default.Statement;
            return sqlconfig;
        }


        public static SyndicationAdapterConfig GetRSSAdapterSettings()
        {
            SyndicationAdapterConfig config = new SyndicationAdapterConfig();
            config.url = RSSFeed.Default.url;
            config.keyword = RSSFeed.Default.keyword;
            config.language = RSSFeed.Default.language;
            return config;
        }
    }
}
